#include <amxmodx>
#include <engine>

#define FIRST_THINK 39546
#define FIRST_TOUCH 23921

new const g_szClassname[] = "colored_smokenade";

new g_szSmokeSprites[ 6 ];
new g_Cvar_Enabled;

public plugin_init( ) {
	register_plugin( "Colored Smoke", "1.0", "xPaw" );
	
	g_Cvar_Enabled = register_cvar( "sv_colored_smoke", "1" );
	
	register_touch( "grenade", "worldspawn", "FwdTouch_Grenade" );
	register_touch( g_szClassname, "worldspawn", "FwdTouch_FakeSmoke" );
	register_think( g_szClassname, "FwdThink_FakeSmoke" );
}

public plugin_precache( ) {
	g_szSmokeSprites[ 0 ] = precache_model( "sprites/gas_puff_01r.spr" );
	g_szSmokeSprites[ 1 ] = precache_model( "sprites/gas_puff_01g.spr" );
	g_szSmokeSprites[ 2 ] = precache_model( "sprites/gas_puff_01b.spr" );
	g_szSmokeSprites[ 3 ] = precache_model( "sprites/gas_puff_01y.spr" );
	g_szSmokeSprites[ 4 ] = precache_model( "sprites/gas_puff_01m.spr" );
	g_szSmokeSprites[ 5 ] = precache_model( "sprites/gas_puff_01o.spr" );
	
	precache_sound( "weapons/grenade_hit1.wav" );
}

public FwdTouch_Grenade( iEntity, iWorld ) {
	if( !get_pcvar_num( g_Cvar_Enabled ) )
		return PLUGIN_CONTINUE;
	
	static const szSmoke[] = "models/w_smokegrenade.mdl";
	static szModel[ 26 ];
	entity_get_string( iEntity, EV_SZ_model, szModel, charsmax( szModel ) );
	
	if( equali( szModel, szSmoke ) ) {
		static Float:vVelocity[ 3 ];
		entity_get_vector( iEntity, EV_VEC_velocity, vVelocity );
		
		if( vector_length( vVelocity ) <= 200.0 ) {
			new iFake = create_entity( "info_target" );
			
			// If created smoke is not valid, let cs explode standart 1 then...
			if( !is_valid_ent( iFake ) )
				return PLUGIN_CONTINUE;
			
			entity_set_string( iFake, EV_SZ_classname, g_szClassname );
			entity_set_edict( iFake, EV_ENT_owner, entity_get_edict( iEntity, EV_ENT_owner ) );
			entity_set_int( iFake, EV_INT_movetype, MOVETYPE_BOUNCE );
			entity_set_int( iFake, EV_INT_solid, SOLID_NOT );
			
			new Float:vOrigin[ 3 ], Float:vAngles[ 3 ];
			entity_get_vector( iEntity, EV_VEC_origin, vOrigin );
			entity_get_vector( iEntity, EV_VEC_angles, vAngles );
			
			entity_set_vector( iFake, EV_VEC_origin, vOrigin );
			vVelocity[ 2 ] += 150.0;
			entity_set_vector( iFake, EV_VEC_velocity, vVelocity );
			entity_set_vector( iFake, EV_VEC_angles, vAngles );
			entity_set_int( iFake, EV_INT_fixangle, 1 );
			entity_set_model( iFake, szModel );
			
			entity_set_int( iFake, EV_INT_iuser3, FIRST_TOUCH );
			entity_set_int( iFake, EV_INT_iuser4, FIRST_THINK );
			entity_set_float( iFake, EV_FL_nextthink, get_gametime( ) + 0.6 );
			
			// Delete Original Smoke
			entity_set_int( iEntity, EV_INT_flags, FL_KILLME );
			
			// Detonate Smoke
			emit_sound( iFake, CHAN_WEAPON, "weapons/sg_explode.wav", 1.0, ATTN_NORM, 0, PITCH_NORM );
			
			new iOrigin[ 3 ], iRandomSmoke;
			FVecIVec( vOrigin, iOrigin );
			iRandomSmoke = random_num( 0, 5 );
			
			message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
			write_byte( TE_FIREFIELD );
			write_coord( iOrigin[ 0 ] );
			write_coord( iOrigin[ 1 ] );
			write_coord( iOrigin[ 2 ] + 50 );
			write_short( 100 );
			write_short( g_szSmokeSprites[ iRandomSmoke ] );
			write_byte( 100 );
			write_byte( TEFIRE_FLAG_ALPHA );
			write_byte( 1000 );
			message_end();

			message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
			write_byte( TE_FIREFIELD );
			write_coord( iOrigin[ 0 ] );
			write_coord( iOrigin[ 1 ] );
			write_coord( iOrigin[ 2 ] + 50 );
			write_short( 150 );
			write_short( g_szSmokeSprites[ iRandomSmoke ] );
			write_byte( 10 );
			write_byte( TEFIRE_FLAG_ALLFLOAT | TEFIRE_FLAG_ALPHA );
			write_byte( 1000 );
			message_end( );
		}
	}
	
	return PLUGIN_CONTINUE;
}

public FwdTouch_FakeSmoke( iEntity, iWorld ) {
	if( !is_valid_ent( iEntity ) )
		return PLUGIN_CONTINUE;
	
	if( entity_get_int( iEntity, EV_INT_iuser3 ) == FIRST_TOUCH ) {
		// Touch sound
		emit_sound( iEntity, CHAN_WEAPON, "weapons/grenade_hit1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM );
		entity_set_int( iEntity, EV_INT_iuser3, 0 );
	}
	
	return PLUGIN_CONTINUE;
}

public FwdThink_FakeSmoke( iEntity ) {
	if( !is_valid_ent( iEntity ) )
		return PLUGIN_CONTINUE;
	
	if( entity_get_int( iEntity, EV_INT_iuser4 ) == FIRST_THINK ) {
		entity_set_int( iEntity, EV_INT_iuser4, 0 );
		entity_set_int( iEntity, EV_INT_movetype, MOVETYPE_TOSS );
		entity_set_float( iEntity, EV_FL_nextthink, get_gametime( ) + 21.0 );
	} else
		remove_entity( iEntity );
	
	return PLUGIN_CONTINUE;
}